#region References

using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Reflection;
using System.Text;
using System.Windows.Forms;
using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;
using VBECSDateTime = gov.va.med.vbecs.BOL.VBECSDateTime;
using ListViewSubItem = System.Windows.Forms.ListViewItem.ListViewSubItem;

#endregion

namespace gov.va.med.vbecs.GUI
{
	#region Header

	//<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	//<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	//<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	//<Developers>
	//	<Developer>Margaret Jablonski</Developer>
	//</Developers>
	//<SiteName>Hines OIFO</SiteName>
	//<CreationDate>7/13/2004</CreationDate>
	//<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	//<summary></summary>

	#endregion

	/// <summary>
	/// Class FrmMergePatients
	/// </summary>
	public class FrmMergePatients : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Delegates
		
		private event EventHandler onViewedMerges;

		#endregion

		#region Variables

		private bool _isCurrentUserAuthorizedToClearMergeAlert;

		private bool _okToClearAlert;

		private const string FORM_NAME = "PatientMerge";
		private const string MERGE_PATIENT_NOT_AVAILABLE = "N/A";
		private const string MERGE_PATIENT_NOT_AVAILABLE_TOOLTIP = "Not available: patient has no VBECS records at the receipt of the merge message.";
		
		private string _clearPatientMergeAlertToolTip;

		/// <summary>
		/// Is form loading
		/// </summary>
		private bool _isLoading = false;

		#endregion

		#region Controls

		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader7;
		private System.Windows.Forms.GroupBox grpSelectedRecord;
		private System.Windows.Forms.GroupBox grpMergeFrom;
		private System.Windows.Forms.GroupBox grpMergeTo;
		private System.Windows.Forms.Panel pnlMerge;
		private System.Windows.Forms.TextBox txtFromName;
		private System.Windows.Forms.Label lblFromName;
		private System.Windows.Forms.TextBox txtFromABORh;
		private System.Windows.Forms.Label lblFromABORh;
		private System.Windows.Forms.TextBox txtFromSSN;
		private System.Windows.Forms.Label lblFromSSN;
		private gov.va.med.vbecs.GUI.controls.PatientInfoToolbar toolbarFrom;
		private gov.va.med.vbecs.GUI.controls.PatientInfoToolbar toolbarTo;
		private System.Windows.Forms.TextBox txtToABORh;
		private System.Windows.Forms.Label lblToABORh;
		private System.Windows.Forms.TextBox txtToSSN;
		private System.Windows.Forms.Label lblToSSN;
		private System.Windows.Forms.TextBox txtToName;
		private System.Windows.Forms.Label lblToName;
		private System.Windows.Forms.TextBox txtDateReceived;
		private System.Windows.Forms.Label lblDateReceived;
		private System.Windows.Forms.ListView lvMerge;
		private System.Windows.Forms.GroupBox grpMergePatients;
		private System.Windows.Forms.TextBox txtToSex;
		private System.Windows.Forms.Label lblToSex;
		private System.Windows.Forms.TextBox txtFromSex;
		private System.Windows.Forms.Label lblFromSex;
		private gov.va.med.vbecs.GUI.controls.SpecialInstructionsDisplayPanel pnlFromSIandTR;
		private gov.va.med.vbecs.GUI.controls.SpecialInstructionsDisplayPanel pnlToSIandTR;
		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnClearPatientMergeAlert;

		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Designer generated code

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmMergePatients));
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.grpSelectedRecord = new System.Windows.Forms.GroupBox();
			this.txtDateReceived = new System.Windows.Forms.TextBox();
			this.lblDateReceived = new System.Windows.Forms.Label();
			this.pnlMerge = new System.Windows.Forms.Panel();
			this.grpMergeTo = new System.Windows.Forms.GroupBox();
			this.pnlToSIandTR = new gov.va.med.vbecs.GUI.controls.SpecialInstructionsDisplayPanel();
			this.txtToSex = new System.Windows.Forms.TextBox();
			this.lblToSex = new System.Windows.Forms.Label();
			this.toolbarTo = new gov.va.med.vbecs.GUI.controls.PatientInfoToolbar();
			this.txtToABORh = new System.Windows.Forms.TextBox();
			this.lblToABORh = new System.Windows.Forms.Label();
			this.txtToSSN = new System.Windows.Forms.TextBox();
			this.lblToSSN = new System.Windows.Forms.Label();
			this.txtToName = new System.Windows.Forms.TextBox();
			this.lblToName = new System.Windows.Forms.Label();
			this.grpMergeFrom = new System.Windows.Forms.GroupBox();
			this.pnlFromSIandTR = new gov.va.med.vbecs.GUI.controls.SpecialInstructionsDisplayPanel();
			this.txtFromSex = new System.Windows.Forms.TextBox();
			this.lblFromSex = new System.Windows.Forms.Label();
			this.toolbarFrom = new gov.va.med.vbecs.GUI.controls.PatientInfoToolbar();
			this.txtFromABORh = new System.Windows.Forms.TextBox();
			this.lblFromABORh = new System.Windows.Forms.Label();
			this.txtFromSSN = new System.Windows.Forms.TextBox();
			this.lblFromSSN = new System.Windows.Forms.Label();
			this.txtFromName = new System.Windows.Forms.TextBox();
			this.lblFromName = new System.Windows.Forms.Label();
			this.lvMerge = new System.Windows.Forms.ListView();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader5 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader7 = new System.Windows.Forms.ColumnHeader();
			this.grpMergePatients = new System.Windows.Forms.GroupBox();
			this.btnClearPatientMergeAlert = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpImage.SuspendLayout();
			this.grpSelectedRecord.SuspendLayout();
			this.pnlMerge.SuspendLayout();
			this.grpMergeTo.SuspendLayout();
			this.grpMergeFrom.SuspendLayout();
			this.grpMergePatients.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(1003, 30);
			this.vbecsLogo1.TabIndex = 3;
			this.vbecsLogo1.Title = "Patient Merge";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 674);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Location = new System.Drawing.Point(925, 663);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Close";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 627);
			this.grpImage.TabIndex = 4;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 45);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 0;
			this.picImage.TabStop = false;
			// 
			// grpSelectedRecord
			// 
			this.grpSelectedRecord.AccessibleDescription = "Selected Merge Record";
			this.grpSelectedRecord.AccessibleName = "Selected Merge Record";
			this.grpSelectedRecord.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSelectedRecord.Controls.Add(this.txtDateReceived);
			this.grpSelectedRecord.Controls.Add(this.lblDateReceived);
			this.grpSelectedRecord.Controls.Add(this.pnlMerge);
			this.grpSelectedRecord.Location = new System.Drawing.Point(0, 132);
			this.grpSelectedRecord.Name = "grpSelectedRecord";
			this.grpSelectedRecord.Size = new System.Drawing.Size(1003, 528);
			this.grpSelectedRecord.TabIndex = 1;
			this.grpSelectedRecord.TabStop = false;
			this.grpSelectedRecord.Text = "Selected Merge Record";
			// 
			// txtDateReceived
			// 
			this.txtDateReceived.AccessibleDescription = "Date Merge Notification Received";
			this.txtDateReceived.AccessibleName = "Date Merge Notification Received";
			this.txtDateReceived.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDateReceived.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtDateReceived.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtDateReceived.Location = new System.Drawing.Point(184, 16);
			this.txtDateReceived.Name = "txtDateReceived";
			this.txtDateReceived.ReadOnly = true;
			this.txtDateReceived.Size = new System.Drawing.Size(809, 20);
			this.txtDateReceived.TabIndex = 1;
			this.txtDateReceived.Text = "";
			// 
			// lblDateReceived
			// 
			this.lblDateReceived.Location = new System.Drawing.Point(16, 16);
			this.lblDateReceived.Name = "lblDateReceived";
			this.lblDateReceived.Size = new System.Drawing.Size(184, 20);
			this.lblDateReceived.TabIndex = 0;
			this.lblDateReceived.Text = "Date Merge Notification Received";
			this.lblDateReceived.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlMerge
			// 
			this.pnlMerge.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlMerge.Controls.Add(this.grpMergeTo);
			this.pnlMerge.Controls.Add(this.grpMergeFrom);
			this.pnlMerge.Location = new System.Drawing.Point(8, 40);
			this.pnlMerge.Name = "pnlMerge";
			this.pnlMerge.Size = new System.Drawing.Size(987, 476);
			this.pnlMerge.TabIndex = 2;
			// 
			// grpMergeTo
			// 
			this.grpMergeTo.AccessibleDescription = "Merge To Patient";
			this.grpMergeTo.AccessibleName = "Merge To Patient";
			this.grpMergeTo.Controls.Add(this.pnlToSIandTR);
			this.grpMergeTo.Controls.Add(this.txtToSex);
			this.grpMergeTo.Controls.Add(this.lblToSex);
			this.grpMergeTo.Controls.Add(this.toolbarTo);
			this.grpMergeTo.Controls.Add(this.txtToABORh);
			this.grpMergeTo.Controls.Add(this.lblToABORh);
			this.grpMergeTo.Controls.Add(this.txtToSSN);
			this.grpMergeTo.Controls.Add(this.lblToSSN);
			this.grpMergeTo.Controls.Add(this.txtToName);
			this.grpMergeTo.Controls.Add(this.lblToName);
			this.grpMergeTo.Dock = System.Windows.Forms.DockStyle.Right;
			this.grpMergeTo.Location = new System.Drawing.Point(507, 0);
			this.grpMergeTo.Name = "grpMergeTo";
			this.grpMergeTo.Size = new System.Drawing.Size(480, 476);
			this.grpMergeTo.TabIndex = 2;
			this.grpMergeTo.TabStop = false;
			this.grpMergeTo.Text = "Merge-To Patient";
			// 
			// pnlToSIandTR
			// 
			this.pnlToSIandTR.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlToSIandTR.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pnlToSIandTR.Location = new System.Drawing.Point(8, 88);
			this.pnlToSIandTR.Name = "pnlToSIandTR";
			this.pnlToSIandTR.Patient = null;
			this.pnlToSIandTR.Size = new System.Drawing.Size(466, 379);
			this.pnlToSIandTR.TabIndex = 9;
			// 
			// txtToSex
			// 
			this.txtToSex.AccessibleDescription = "Sex";
			this.txtToSex.AccessibleName = "Sex";
			this.txtToSex.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtToSex.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtToSex.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtToSex.Location = new System.Drawing.Point(342, 64);
			this.txtToSex.Name = "txtToSex";
			this.txtToSex.ReadOnly = true;
			this.txtToSex.Size = new System.Drawing.Size(52, 20);
			this.txtToSex.TabIndex = 7;
			this.txtToSex.Text = "";
			// 
			// lblToSex
			// 
			this.lblToSex.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblToSex.Location = new System.Drawing.Point(316, 64);
			this.lblToSex.Name = "lblToSex";
			this.lblToSex.Size = new System.Drawing.Size(24, 20);
			this.lblToSex.TabIndex = 6;
			this.lblToSex.Text = "Sex";
			this.lblToSex.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// toolbarTo
			// 
			this.toolbarTo.AccessibleDescription = "patient information";
			this.toolbarTo.AccessibleName = "patient information";
			this.toolbarTo.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.toolbarTo.EnabledBloodAvailButton = false;
			this.toolbarTo.EnabledMedicationButton = false;
			this.toolbarTo.EnabledRecentOrdersButton = false;
			this.toolbarTo.EnabledRecentTransfusionsIssuesButton = false;
			this.toolbarTo.EnabledSIAndTRButton = false;
			this.toolbarTo.EnabledTransfusionReactionHistoryButton = false;
			this.toolbarTo.Location = new System.Drawing.Point(398, 40);
			this.toolbarTo.Name = "toolbarTo";
			this.toolbarTo.ParentFormInstanceGuid = new System.Guid("00000000-0000-0000-0000-000000000000");
			this.toolbarTo.Patient = null;
			this.toolbarTo.SingleRowDisplay = false;
			this.toolbarTo.Size = new System.Drawing.Size(76, 42);
			this.toolbarTo.TabIndex = 8;
			// 
			// txtToABORh
			// 
			this.txtToABORh.AccessibleDescription = "A B O R H";
			this.txtToABORh.AccessibleName = "A B O R H";
			this.txtToABORh.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtToABORh.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtToABORh.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtToABORh.Location = new System.Drawing.Point(56, 64);
			this.txtToABORh.Name = "txtToABORh";
			this.txtToABORh.ReadOnly = true;
			this.txtToABORh.Size = new System.Drawing.Size(250, 20);
			this.txtToABORh.TabIndex = 5;
			this.txtToABORh.Text = "";
			// 
			// lblToABORh
			// 
			this.lblToABORh.Location = new System.Drawing.Point(8, 64);
			this.lblToABORh.Name = "lblToABORh";
			this.lblToABORh.Size = new System.Drawing.Size(52, 20);
			this.lblToABORh.TabIndex = 4;
			this.lblToABORh.Text = "ABO/Rh";
			this.lblToABORh.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtToSSN
			// 
			this.txtToSSN.AccessibleDescription = "Patient I D";
			this.txtToSSN.AccessibleName = "Patient I D";
			this.txtToSSN.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtToSSN.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtToSSN.Location = new System.Drawing.Point(56, 40);
			this.txtToSSN.Name = "txtToSSN";
			this.txtToSSN.ReadOnly = true;
			this.txtToSSN.Size = new System.Drawing.Size(338, 20);
			this.txtToSSN.TabIndex = 3;
			this.txtToSSN.Text = "";
			// 
			// lblToSSN
			// 
			this.lblToSSN.Location = new System.Drawing.Point(8, 40);
			this.lblToSSN.Name = "lblToSSN";
			this.lblToSSN.Size = new System.Drawing.Size(56, 20);
			this.lblToSSN.TabIndex = 2;
			this.lblToSSN.Text = "Patient ID";
			this.lblToSSN.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtToName
			// 
			this.txtToName.AccessibleDescription = "Name";
			this.txtToName.AccessibleName = "Name";
			this.txtToName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtToName.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtToName.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtToName.Location = new System.Drawing.Point(56, 16);
			this.txtToName.Name = "txtToName";
			this.txtToName.ReadOnly = true;
			this.txtToName.Size = new System.Drawing.Size(418, 20);
			this.txtToName.TabIndex = 1;
			this.txtToName.Text = "";
			// 
			// lblToName
			// 
			this.lblToName.Location = new System.Drawing.Point(8, 16);
			this.lblToName.Name = "lblToName";
			this.lblToName.Size = new System.Drawing.Size(52, 20);
			this.lblToName.TabIndex = 0;
			this.lblToName.Text = "Name";
			this.lblToName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpMergeFrom
			// 
			this.grpMergeFrom.AccessibleDescription = "Merge From Patient";
			this.grpMergeFrom.AccessibleName = "Merge From Patient";
			this.grpMergeFrom.Controls.Add(this.pnlFromSIandTR);
			this.grpMergeFrom.Controls.Add(this.txtFromSex);
			this.grpMergeFrom.Controls.Add(this.lblFromSex);
			this.grpMergeFrom.Controls.Add(this.toolbarFrom);
			this.grpMergeFrom.Controls.Add(this.txtFromABORh);
			this.grpMergeFrom.Controls.Add(this.lblFromABORh);
			this.grpMergeFrom.Controls.Add(this.txtFromSSN);
			this.grpMergeFrom.Controls.Add(this.lblFromSSN);
			this.grpMergeFrom.Controls.Add(this.txtFromName);
			this.grpMergeFrom.Controls.Add(this.lblFromName);
			this.grpMergeFrom.Dock = System.Windows.Forms.DockStyle.Left;
			this.grpMergeFrom.Location = new System.Drawing.Point(0, 0);
			this.grpMergeFrom.Name = "grpMergeFrom";
			this.grpMergeFrom.Size = new System.Drawing.Size(492, 476);
			this.grpMergeFrom.TabIndex = 0;
			this.grpMergeFrom.TabStop = false;
			this.grpMergeFrom.Text = "Merge-From Patient";
			// 
			// pnlFromSIandTR
			// 
			this.pnlFromSIandTR.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlFromSIandTR.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pnlFromSIandTR.Location = new System.Drawing.Point(8, 88);
			this.pnlFromSIandTR.Name = "pnlFromSIandTR";
			this.pnlFromSIandTR.Patient = null;
			this.pnlFromSIandTR.Size = new System.Drawing.Size(472, 379);
			this.pnlFromSIandTR.TabIndex = 9;
			// 
			// txtFromSex
			// 
			this.txtFromSex.AccessibleDescription = "Sex";
			this.txtFromSex.AccessibleName = "Sex";
			this.txtFromSex.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtFromSex.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtFromSex.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtFromSex.Location = new System.Drawing.Point(352, 64);
			this.txtFromSex.Name = "txtFromSex";
			this.txtFromSex.ReadOnly = true;
			this.txtFromSex.Size = new System.Drawing.Size(52, 20);
			this.txtFromSex.TabIndex = 7;
			this.txtFromSex.Text = "";
			// 
			// lblFromSex
			// 
			this.lblFromSex.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblFromSex.Location = new System.Drawing.Point(328, 64);
			this.lblFromSex.Name = "lblFromSex";
			this.lblFromSex.Size = new System.Drawing.Size(24, 20);
			this.lblFromSex.TabIndex = 6;
			this.lblFromSex.Text = "Sex";
			this.lblFromSex.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// toolbarFrom
			// 
			this.toolbarFrom.AccessibleDescription = "Patient information";
			this.toolbarFrom.AccessibleName = "Patient information";
			this.toolbarFrom.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.toolbarFrom.EnabledBloodAvailButton = false;
			this.toolbarFrom.EnabledMedicationButton = false;
			this.toolbarFrom.EnabledRecentOrdersButton = false;
			this.toolbarFrom.EnabledRecentTransfusionsIssuesButton = false;
			this.toolbarFrom.EnabledSIAndTRButton = false;
			this.toolbarFrom.EnabledTransfusionReactionHistoryButton = false;
			this.toolbarFrom.Location = new System.Drawing.Point(408, 40);
			this.toolbarFrom.Name = "toolbarFrom";
			this.toolbarFrom.ParentFormInstanceGuid = new System.Guid("00000000-0000-0000-0000-000000000000");
			this.toolbarFrom.Patient = null;
			this.toolbarFrom.SingleRowDisplay = false;
			this.toolbarFrom.Size = new System.Drawing.Size(76, 42);
			this.toolbarFrom.TabIndex = 8;
			// 
			// txtFromABORh
			// 
			this.txtFromABORh.AccessibleDescription = "A B O R H";
			this.txtFromABORh.AccessibleName = "A B O R H";
			this.txtFromABORh.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtFromABORh.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtFromABORh.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtFromABORh.Location = new System.Drawing.Point(56, 64);
			this.txtFromABORh.Name = "txtFromABORh";
			this.txtFromABORh.ReadOnly = true;
			this.txtFromABORh.Size = new System.Drawing.Size(264, 20);
			this.txtFromABORh.TabIndex = 5;
			this.txtFromABORh.Text = "";
			// 
			// lblFromABORh
			// 
			this.lblFromABORh.Location = new System.Drawing.Point(8, 64);
			this.lblFromABORh.Name = "lblFromABORh";
			this.lblFromABORh.Size = new System.Drawing.Size(52, 20);
			this.lblFromABORh.TabIndex = 4;
			this.lblFromABORh.Text = "ABO/Rh";
			this.lblFromABORh.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtFromSSN
			// 
			this.txtFromSSN.AccessibleDescription = "Patient I D";
			this.txtFromSSN.AccessibleName = "Patient I D";
			this.txtFromSSN.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtFromSSN.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtFromSSN.Location = new System.Drawing.Point(56, 40);
			this.txtFromSSN.Name = "txtFromSSN";
			this.txtFromSSN.ReadOnly = true;
			this.txtFromSSN.Size = new System.Drawing.Size(348, 20);
			this.txtFromSSN.TabIndex = 3;
			this.txtFromSSN.Text = "";
			// 
			// lblFromSSN
			// 
			this.lblFromSSN.Location = new System.Drawing.Point(8, 40);
			this.lblFromSSN.Name = "lblFromSSN";
			this.lblFromSSN.Size = new System.Drawing.Size(56, 20);
			this.lblFromSSN.TabIndex = 2;
			this.lblFromSSN.Text = "Patient ID";
			this.lblFromSSN.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtFromName
			// 
			this.txtFromName.AccessibleDescription = "Name";
			this.txtFromName.AccessibleName = "Name";
			this.txtFromName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtFromName.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtFromName.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtFromName.Location = new System.Drawing.Point(56, 16);
			this.txtFromName.Name = "txtFromName";
			this.txtFromName.ReadOnly = true;
			this.txtFromName.Size = new System.Drawing.Size(428, 20);
			this.txtFromName.TabIndex = 1;
			this.txtFromName.Text = "";
			// 
			// lblFromName
			// 
			this.lblFromName.Location = new System.Drawing.Point(8, 16);
			this.lblFromName.Name = "lblFromName";
			this.lblFromName.Size = new System.Drawing.Size(52, 20);
			this.lblFromName.TabIndex = 0;
			this.lblFromName.Text = "Name";
			this.lblFromName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lvMerge
			// 
			this.lvMerge.AccessibleDescription = "Merge Patient Records";
			this.lvMerge.AccessibleName = "Merge Patient Records";
			this.lvMerge.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvMerge.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																					  this.columnHeader4,
																					  this.columnHeader1,
																					  this.columnHeader5,
																					  this.columnHeader2,
																					  this.columnHeader7});
			this.lvMerge.FullRowSelect = true;
			this.lvMerge.HideSelection = false;
			this.lvMerge.Location = new System.Drawing.Point(3, 16);
			this.lvMerge.MultiSelect = false;
			this.lvMerge.Name = "lvMerge";
			this.lvMerge.Size = new System.Drawing.Size(933, 76);
			this.lvMerge.TabIndex = 0;
			this.lvMerge.View = System.Windows.Forms.View.Details;
			this.lvMerge.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvMerge_ColumnClick);
			this.lvMerge.SelectedIndexChanged += new System.EventHandler(this.lvMerge_SelectedIndexChanged);
			// 
			// columnHeader4
			// 
			this.columnHeader4.Text = "Merge-From Name";
			this.columnHeader4.Width = 130;
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "Merge-To Name";
			this.columnHeader1.Width = 130;
			// 
			// columnHeader5
			// 
			this.columnHeader5.Text = "Merge-From ID";
			this.columnHeader5.Width = 85;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Merge-To ID";
			this.columnHeader2.Width = 80;
			// 
			// columnHeader7
			// 
			this.columnHeader7.Text = "Date Updated";
			this.columnHeader7.Width = 90;
			// 
			// grpMergePatients
			// 
			this.grpMergePatients.AccessibleDescription = "Merge Patient Records";
			this.grpMergePatients.AccessibleName = "Merge Patient Records";
			this.grpMergePatients.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpMergePatients.Controls.Add(this.lvMerge);
			this.grpMergePatients.Location = new System.Drawing.Point(60, 32);
			this.grpMergePatients.Name = "grpMergePatients";
			this.grpMergePatients.Size = new System.Drawing.Size(939, 100);
			this.grpMergePatients.TabIndex = 0;
			this.grpMergePatients.TabStop = false;
			this.grpMergePatients.Text = "Merge Patient Records";
			// 
			// btnClearPatientMergeAlert
			// 
			this.btnClearPatientMergeAlert.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnClearPatientMergeAlert.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnClearPatientMergeAlert.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnClearPatientMergeAlert.Image = null;
			this.btnClearPatientMergeAlert.Location = new System.Drawing.Point(744, 664);
			this.btnClearPatientMergeAlert.Name = "btnClearPatientMergeAlert";
			this.btnClearPatientMergeAlert.Size = new System.Drawing.Size(156, 23);
			this.btnClearPatientMergeAlert.TabIndex = 6;
			this.btnClearPatientMergeAlert.Click += new System.EventHandler(this.btnClearPatientMergeAlert_Click);
			this.btnClearPatientMergeAlert.MouseHover += new System.EventHandler(this.btnClearPatientMergeAlert_MouseHover);
			// 
			// FrmMergePatients
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(1003, 690);
			this.Controls.Add(this.grpSelectedRecord);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpMergePatients);
			this.Controls.Add(this.btnClearPatientMergeAlert);
			this.hlphelpChm.SetHelpKeyword(this, "Patient_Merge.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(795, 509);
			this.Name = "FrmMergePatients";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Patient Merge";
			this.Resize += new System.EventHandler(this.FrmMergePatients_Resize);
			this.Closing += new System.ComponentModel.CancelEventHandler(this.FrmMergePatients_Closing);
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmMergePatients_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.btnClearPatientMergeAlert, 0);
			this.Controls.SetChildIndex(this.grpMergePatients, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpSelectedRecord, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpImage.ResumeLayout(false);
			this.grpSelectedRecord.ResumeLayout(false);
			this.pnlMerge.ResumeLayout(false);
			this.grpMergeTo.ResumeLayout(false);
			this.grpMergeFrom.ResumeLayout(false);
			this.grpMergePatients.ResumeLayout(false);
			this.ResumeLayout(false);

		}

		#endregion

		#region Constructors/Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmMergePatients()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC068DuplicatePatientMerge;
			//
			this._isLoading = true;
			//
			InitializeComponent();
			//
			SetComponentProperties();
			//
			LoadListView();
			this.btnClearPatientMergeAlert.Text = "Clear Patient &Merge Alert";
			//
			this._isLoading = false;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Events / Event Handlers

		/// <summary>
		/// ViewedMerges
		/// </summary>
		public event EventHandler ViewedMerges
		{
			add
			{
				onViewedMerges += value;
			}
			remove
			{
				onViewedMerges -= value;
			}
		}

		/// <summary>
		/// OnViewedMerges
		/// </summary>
		private void OnViewedMerges(object sender, EventArgs e)
		{
			if (onViewedMerges != null)
			{
				onViewedMerges(this, e);
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>07/13/2004</CreationDate>
		/// <summary>
		/// We're outtta here!
		/// </summary>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			//
			this.Close();
		}

		/// <summary>
		/// FrmMergePatients_Closing
		/// Implements BR_68.13
		/// </summary>
		private void FrmMergePatients_Closing(object sender, CancelEventArgs e)
		{
			// Clear the alert icon if all merge events have been cleared
			if(this._okToClearAlert)
			{
				OnViewedMerges(null, EventArgs.Empty);
			}
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/03/2006</CreationDate>
		/// <summary>
		/// Sets PatientChangeStatus == 'S' for selected merge event; 
		/// clears merge alert after checking if PatientChangeStatus == 'S' 
		/// for each merge record in the ListView
		/// Implements BR_68.13
		/// </summary>
		/// <remarks>
		/// We do not actually merge patient records in VBECS
		/// </remarks>
		private void btnClearPatientMergeAlert_Click(object sender, System.EventArgs e)
		{
			PatientChange patientChange  = (PatientChange)lvMerge.SelectedItems[0].Tag;
			//
			if(patientChange != null)
			{
				DialogResult dr = GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC068.ClearPatientMergeAlertWarning());
				//
				if (dr == DialogResult.OK)
				{
					// We need to mark the records the user viewed as such, so they will not appear in the user alert;
					// to do this we update the PatientChangeStatusCode to 'S' (Successfully Processed)
					//
					patientChange.PatientChangeStatusCode = Common.PatientChangeStatus.SuccessfullyProcessed;
					//

					patientChange.UpdatePatientChangeStatus();
					//
					LoadListView();
					//
					btnClearPatientMergeAlert.EnabledButton = false;
				}
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>07/13/2004</CreationDate>
		/// <summary>
		/// Mouse Hover event handler, displys tooltips
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		/// <remarks>
		/// Merge is disabled in this version of VBECS
		/// </remarks>
		private void btnClearPatientMergeAlert_MouseHover(object sender, System.EventArgs e)
		{
			if(!_isLoading)
			{
				this.ttToolTip.SetToolTip(this.btnClearPatientMergeAlert, _clearPatientMergeAlertToolTip);
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>07/13/2004</CreationDate>
		/// <summary>
		/// Display detail information for the selected row. Implements BR_68.16, BR_68.20
		/// </summary>
		private void lvMerge_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			try
			{
				// Clear Tooltips
				this.ttToolTip.SetToolTip(this.txtFromABORh, string.Empty);
				this.ttToolTip.SetToolTip(this.txtFromName, string.Empty);
				this.ttToolTip.SetToolTip(this.txtFromSex, string.Empty);
				this.ttToolTip.SetToolTip(this.txtFromSSN, string.Empty);
				this.ttToolTip.SetToolTip(this.txtToABORh, string.Empty);
				this.ttToolTip.SetToolTip(this.txtToName, string.Empty);
				this.ttToolTip.SetToolTip(this.txtToSex, string.Empty);
				this.ttToolTip.SetToolTip(this.txtToSSN, string.Empty);
				//
				btnClearPatientMergeAlert.EnabledButton = false;
				//
				if(lvMerge.SelectedItems.Count == 1 && this.lvMerge.SelectedItems[0].Tag != null)
				{
					PatientChange patientChange  = (PatientChange)lvMerge.SelectedItems[0].Tag;
					//
					if (patientChange.FromPatientGuid != Guid.Empty )
					{
						Patient mergeFromPatient = new Patient(patientChange.FromPatientGuid); 
						//
						txtFromABORh.Text = mergeFromPatient.AboRh.AboRHText;
						this.ttToolTip.SetToolTip(this.txtFromABORh, mergeFromPatient.GetPatientHistoricABORhForTooltip());
						txtFromName.Text = mergeFromPatient.DisplayName;
						txtFromSex.Text = mergeFromPatient.Sex.ToString();
						txtFromSSN.Text = mergeFromPatient.DisplayPatientID;
						//
						pnlFromSIandTR.Patient = mergeFromPatient;
						this.toolbarFrom.Patient = mergeFromPatient;
						toolbarFrom.EnabledSIAndTRButton = false;
					}
					else
					{
						txtFromABORh.Text = MERGE_PATIENT_NOT_AVAILABLE;
						this.ttToolTip.SetToolTip(this.txtFromABORh, MERGE_PATIENT_NOT_AVAILABLE_TOOLTIP);
						//
						// CR 2931
						string displayName = Patient.BuildDisplayName(patientChange.FromPatientFirstName, patientChange.FromPatientMiddleName, patientChange.FromPatientLastName);
						txtFromName.Text = displayName == null || displayName == string.Empty ? MERGE_PATIENT_NOT_AVAILABLE : displayName;
						//
						txtFromSex.Text = MERGE_PATIENT_NOT_AVAILABLE;
						this.ttToolTip.SetToolTip(this.txtFromSex, MERGE_PATIENT_NOT_AVAILABLE_TOOLTIP);
						//
						txtFromSSN.Text = MERGE_PATIENT_NOT_AVAILABLE;
						this.ttToolTip.SetToolTip(this.txtFromSSN, MERGE_PATIENT_NOT_AVAILABLE_TOOLTIP);
					}
					//
					if ( patientChange.ToPatientGuid != Guid.Empty )
					{
						Patient mergeToPatient = new Patient(patientChange.ToPatientGuid);
						//
						txtToABORh.Text = mergeToPatient.AboRh.AboRHText;
						this.ttToolTip.SetToolTip(this.txtToABORh, mergeToPatient.GetPatientHistoricABORhForTooltip());
						txtToName.Text = mergeToPatient.DisplayName;
						txtToSex.Text = mergeToPatient.Sex.ToString();
						txtToSSN.Text = mergeToPatient.DisplayPatientID;
						//
						pnlToSIandTR.Patient = mergeToPatient;
						this.toolbarTo.Patient = mergeToPatient;
						toolbarTo.EnabledSIAndTRButton = false;
					}
					else
					{
						txtToABORh.Text = MERGE_PATIENT_NOT_AVAILABLE;
						this.ttToolTip.SetToolTip(this.txtToABORh, MERGE_PATIENT_NOT_AVAILABLE_TOOLTIP);
						//
						txtToName.Text = Patient.BuildDisplayName(patientChange.ToPatientFirstName, patientChange.ToPatientMiddleName, patientChange.ToPatientLastName);
						//
						if(patientChange.ToPatientSexCode == null || patientChange.ToPatientSexCode == String.Empty)
						{
							txtToSex.Text = MERGE_PATIENT_NOT_AVAILABLE;
							this.ttToolTip.SetToolTip(this.txtToSex, MERGE_PATIENT_NOT_AVAILABLE_TOOLTIP);
						}
						else
						{
							txtToSex.Text = Common.Utility.GetSexEnumFromSexChar(Convert.ToChar(patientChange.ToPatientSexCode)).ToString();
						}
						//
						txtToSSN.Text = patientChange.ToPatientDisplayVistaPatientId;
					}
					//
					// CR 2675
					txtDateReceived.Text = (Common.VBECSDateTime.FormatDateTimeString(patientChange.NotificationReceivedDate)); 
					//
					// Implements BR_68.16
					if(_isCurrentUserAuthorizedToClearMergeAlert)
					{
						if(patientChange.PatientChangeStatusCode == Common.PatientChangeStatus.SuccessfullyProcessed)
						{
							_clearPatientMergeAlertToolTip = Common.StrRes.Tooltips.UC068.AlertCleared().ResString;
						}
						else
						{
							btnClearPatientMergeAlert.EnabledButton = true;
							//
							_clearPatientMergeAlertToolTip = string.Empty;
						}
					}
					else
					{
						_clearPatientMergeAlertToolTip = Common.StrRes.InfoMsg.Common.InsufficientSecurityPrivileges("this function").ResString;
					}
					//
					// CR 2609
					pnlFromSIandTR.UpdateTransfusionRequirementsPanelHeight();
					pnlToSIandTR.UpdateTransfusionRequirementsPanelHeight();
				}
				else // User has de-selected a row
				{
					this.ClearFormControls();
					//
					if(_isCurrentUserAuthorizedToClearMergeAlert)
					{
						_clearPatientMergeAlertToolTip = Common.StrRes.Tooltips.UC068.SelectMergePatient().ResString;
					}
					else
					{
						_clearPatientMergeAlertToolTip = Common.StrRes.InfoMsg.Common.InsufficientSecurityPrivileges("this function").ResString;
					}
				}
			}
			catch (Exception ex)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(ex.Message));
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>07/13/2004</CreationDate>
		/// <summary>
		/// Sorts the list
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvMerge_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if(!_isLoading)
			{
				if (e.Column == 4)
				{
					controls.ColumnClickSorter.ColumnClickHandler(sender, e, false, controls.ColumnClickSorter.ColumnSortType.DateTime);
				}
				else 
				{
					controls.ColumnClickSorter.ColumnClickHandler(sender, e, false, controls.ColumnClickSorter.ColumnSortType.String);
				}
			}
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>09/18/2006</CreationDate>
		/// <summary>
		/// Re-size the merge-from and merge-to groups appropriately
		/// 
		/// CR 2609: removed forcing of maximized window state, added call to UpdateTransfusionRequirementsPanelHeight() 
		/// from SpecialInstructionsDisplayPanel controls to ensure the pnlAntibodies/pnlAntigens and 
		/// pnlComponentRequirements are at equal height for maximum visibility.
		/// </summary>
		private void FrmMergePatients_Resize(object sender, EventArgs e)
		{
			if ( this.WindowState != FormWindowState.Minimized )
			{
				int newWidth = (this.Width - 30) >> 1;
				//
				this.grpMergeFrom.Width = newWidth;
				this.grpMergeTo.Width = newWidth;
				// 
				pnlFromSIandTR.UpdateTransfusionRequirementsPanelHeight();
				pnlToSIandTR.UpdateTransfusionRequirementsPanelHeight();
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmMergePatients_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			ArrayList toolTips = new ArrayList();
			//
			StringBuilder textToSpeak = new StringBuilder();
			//
			string txtFromABORhToolTip = this.ttToolTip.GetToolTip(txtFromABORh);
			if ( txtFromABORhToolTip != null && txtFromABORhToolTip.Length > 0
				&& ( txtFromABORhToolTip == MERGE_PATIENT_NOT_AVAILABLE
				|| txtFromABORhToolTip == MERGE_PATIENT_NOT_AVAILABLE
				|| txtFromABORhToolTip == MERGE_PATIENT_NOT_AVAILABLE_TOOLTIP))
			{
				toolTips.Add(string.Concat("Merge-From Patient ABO/Rh:", txtFromABORhToolTip));
			}
			//
			string txtFromNameToolTip = this.ttToolTip.GetToolTip(txtFromName);
			if ( txtFromNameToolTip != null && txtFromNameToolTip.Length > 0
				&& ( txtFromNameToolTip == MERGE_PATIENT_NOT_AVAILABLE
				|| txtFromNameToolTip == MERGE_PATIENT_NOT_AVAILABLE
				|| txtFromNameToolTip == MERGE_PATIENT_NOT_AVAILABLE_TOOLTIP))
			{
				toolTips.Add(string.Concat("Merge-From Patient Name:", txtFromNameToolTip));
			}
			//
			string txtFromSexToolTip = this.ttToolTip.GetToolTip(txtFromSex);
			if ( txtFromSexToolTip != null && txtFromSexToolTip.Length > 0
				&& ( txtFromSexToolTip == MERGE_PATIENT_NOT_AVAILABLE
				|| txtFromSexToolTip == MERGE_PATIENT_NOT_AVAILABLE
				|| txtFromSexToolTip == MERGE_PATIENT_NOT_AVAILABLE_TOOLTIP))
			{
				toolTips.Add(string.Concat("Merge-From Patient Sex:", txtFromSexToolTip)); 
			}
			//
			string txtFromSSNToolTip = this.ttToolTip.GetToolTip(txtFromSSN);
			if ( txtFromSSNToolTip != null && txtFromSSNToolTip.Length > 0
				&& ( txtFromSSNToolTip == MERGE_PATIENT_NOT_AVAILABLE
				|| txtFromSSNToolTip == MERGE_PATIENT_NOT_AVAILABLE
				|| txtFromSSNToolTip == MERGE_PATIENT_NOT_AVAILABLE_TOOLTIP))
			{
				toolTips.Add(string.Concat("Merge-From Patient ID:", txtFromSSNToolTip)); 
			}
			//
			string txtToABORhToolTip = this.ttToolTip.GetToolTip(txtToABORh);
			if ( txtToABORhToolTip != null && txtToABORhToolTip.Length > 0
				&& ( txtToABORhToolTip == MERGE_PATIENT_NOT_AVAILABLE
				|| txtToABORhToolTip == MERGE_PATIENT_NOT_AVAILABLE
				|| txtToABORhToolTip == MERGE_PATIENT_NOT_AVAILABLE_TOOLTIP))
			{
				toolTips.Add(string.Concat("Merge-To Patient ABO/Rh:", txtToABORhToolTip)); 
			}
			//
			string txtToNameToolTip = this.ttToolTip.GetToolTip(txtToName);
			if ( txtToNameToolTip != null && txtToNameToolTip.Length > 0
				&& ( txtToNameToolTip == MERGE_PATIENT_NOT_AVAILABLE
				|| txtToNameToolTip == MERGE_PATIENT_NOT_AVAILABLE
				|| txtToNameToolTip == MERGE_PATIENT_NOT_AVAILABLE_TOOLTIP))
			{
				toolTips.Add(string.Concat("Merge-To Patient Name:", txtToNameToolTip)); 
			}
			//
			string txtToSexToolTip = this.ttToolTip.GetToolTip(txtToSex);
			if ( txtToSexToolTip != null && txtToSexToolTip.Length > 0
				&& ( txtToSexToolTip == MERGE_PATIENT_NOT_AVAILABLE
				|| txtToSexToolTip == MERGE_PATIENT_NOT_AVAILABLE
				|| txtToSexToolTip == MERGE_PATIENT_NOT_AVAILABLE_TOOLTIP))
			{
				toolTips.Add(string.Concat("Merge-To Patient Sex:", txtToSexToolTip)); 
			}
			//
			string txtToSSNToolTip = this.ttToolTip.GetToolTip(txtToSSN);
			if ( txtToSSNToolTip != null && txtToSSNToolTip.Length > 0
				&& ( txtToSSNToolTip == MERGE_PATIENT_NOT_AVAILABLE
				|| txtToSSNToolTip == MERGE_PATIENT_NOT_AVAILABLE
				|| txtToSSNToolTip == MERGE_PATIENT_NOT_AVAILABLE_TOOLTIP))
			{
				toolTips.Add(string.Concat("Merge-To Patient ID:", txtToSSNToolTip)); 
			}
			//
			if (!btnClearPatientMergeAlert.EnabledButton && this._clearPatientMergeAlertToolTip != string.Empty) 
			{
				toolTips.Add(_clearPatientMergeAlertToolTip); 
			}
			//
			if ( toolTips != null && toolTips.Count > 0 )
			{
				for (int i = 0; i < toolTips.Count; i++)
				{
					textToSpeak.Append(toolTips[i]).Append(" ");
				}
				//
				this.SpeakMessage( textToSpeak.ToString() );
			}
		}

		#endregion

		#region Methods

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>07/13/2004</CreationDate>
		/// <summary>
		/// Loads pending merge list view
		/// </summary>
		private void LoadListView()
		{
			this.lvMerge.Items.Clear();
			//
			this._okToClearAlert = true;
			//
			// Implements BR_68.19
			PatientChange [] mergeList = BOL.PatientChange.GetPendingPatientMergesDetails();
			//
			if (mergeList != null)
			{
				int recordCount = mergeList.Length;
				//
				if(recordCount > 0)
				{
					for (int idx = 0; idx < recordCount; idx++)
					{
						ListViewItem lVI = new ListViewItem();
						//
						// ************************************************************************************************************************************************************
						// Merge-From Name
						// CR 2931
						string displayName = Patient.BuildDisplayName(mergeList[idx].FromPatientFirstName, mergeList[idx].FromPatientMiddleName, mergeList[idx].FromPatientLastName);
						lVI.Text = displayName == null || displayName == string.Empty ? MERGE_PATIENT_NOT_AVAILABLE : displayName;
						// ************************************************************************************************************************************************************
						// Merge-To Name
						lVI.SubItems.Add(Patient.BuildDisplayName(mergeList[idx].ToPatientFirstName, mergeList[idx].ToPatientMiddleName, mergeList[idx].ToPatientLastName));
						// ************************************************************************************************************************************************************
						// Merge-From ID
						// CR 2566
						if ( mergeList[idx].FromPatientDisplayVistaPatientId != null 
							&& mergeList[idx].FromPatientDisplayVistaPatientId.Length > 0 )
						{
							lVI.SubItems.Add(mergeList[idx].FromPatientDisplayVistaPatientId);
						}
						else
						{
							lVI.SubItems.Add(MERGE_PATIENT_NOT_AVAILABLE);
						}
						// ************************************************************************************************************************************************************
						// Merge-To ID
						lVI.SubItems.Add(mergeList[idx].ToPatientDisplayVistaPatientId);
						// ************************************************************************************************************************************************************
						// Date Received
						lVI.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(mergeList[idx].LastUpdateDate));
						// ************************************************************************************************************************************************************
						lVI.Tag = mergeList[idx];
						//
						this.lvMerge.Items.Add(lVI);
						// 
						if(this._okToClearAlert && mergeList[idx].PatientChangeStatusCode != Common.PatientChangeStatus.SuccessfullyProcessed)
						{
							this._okToClearAlert = false;
						}
					}
				}
			}
			else // No units found in database
			{
				btnClearPatientMergeAlert.EnabledButton = false;
				ListViewItem lvItem = new ListViewItem(Common.StrRes.SysErrMsg.Common.NoDataRowsFoundException("").ResString);
				this.lvMerge.Items.Add(lvItem);
				lvItem.Tag = null;
			}
			//
			controls.VbecsFunction.SetColumnWidths(this.lvMerge);
		}
	
		/// <summary>    
		/// </summary>
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";

			// Define the secuity behavior for btnClearPatientMergeAlert
			_isCurrentUserAuthorizedToClearMergeAlert = IsCurrentUserAuthorizedForFunction(FunctionCode.EditPermanentRecordPatientHistoricABORh);

			if(_isCurrentUserAuthorizedToClearMergeAlert)
			{
				_clearPatientMergeAlertToolTip = Common.StrRes.Tooltips.UC068.SelectMergePatient().ResString;
			}
			else
			{
				_clearPatientMergeAlertToolTip = Common.StrRes.InfoMsg.Common.InsufficientSecurityPrivileges("this function").ResString;
			}

			// Initially disabled
			btnClearPatientMergeAlert.EnabledButton = false; 

			//Set the tooltips of the controls
			this.ttToolTip.SetToolTip(this.btnCancel, Common.StrRes.Tooltips.Common.Cancel().ResString);
		}

		/// <summary>
		/// Function that clears form controls     
		/// </summary>
		private void ClearFormControls()
		{
			txtFromABORh.Text = String.Empty;
			txtFromName.Text = String.Empty;
			txtFromSex.Text = String.Empty;
			txtFromSSN.Text = String.Empty;
			txtToABORh.Text = String.Empty;
			txtToName.Text = String.Empty;
			txtToSex.Text = String.Empty;
			txtToSSN.Text = String.Empty;
			txtDateReceived.Text = String.Empty;
			pnlFromSIandTR.Patient = null;
			pnlToSIandTR.Patient = null;
			toolbarFrom.Patient = null;
			toolbarTo.Patient = null;
		}

		#endregion
	}
}

